/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.Domain;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.MessageRepresentation;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAOUtils;
import org.apache.james.mailbox.postgres.mail.dto.AttachmentsDTO;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.jooq.Record;
import org.jooq.postgres.extensions.types.Hstore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PostgresMessageDAO {
    public static final long DEFAULT_LONG_VALUE = 0L;
    private final PostgresExecutor postgresExecutor;
    private final BlobId.Factory blobIdFactory;

    @Inject
    public PostgresMessageDAO(@Named(value="by_pass_rls") PostgresExecutor postgresExecutor, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.blobIdFactory = blobIdFactory;
    }

    public Mono<Void> insert(MailboxMessage message, String bodyBlobId) {
        return Mono.fromCallable(() -> IOUtils.toByteArray((InputStream)message.getHeaderContent(), (long)message.getHeaderOctets())).subscribeOn(Schedulers.boundedElastic()).flatMap(headerContentAsByte -> this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMessageDataDefinition.MessageTable.TABLE_NAME).set(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID, (Object)((PostgresMessageId)message.getMessageId()).asUuid()).set(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID, (Object)bodyBlobId).set(PostgresMessageDataDefinition.MessageTable.MIME_TYPE, (Object)message.getMediaType()).set(PostgresMessageDataDefinition.MessageTable.MIME_SUBTYPE, (Object)message.getSubType()).set(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, (Object)((LocalDateTime)PostgresCommons.DATE_TO_LOCAL_DATE_TIME.apply(message.getInternalDate()))).set(PostgresMessageDataDefinition.MessageTable.SIZE, (Object)message.getFullContentOctets()).set(PostgresMessageDataDefinition.MessageTable.BODY_START_OCTET, (Object)((int)(message.getFullContentOctets() - message.getBodyOctets()))).set(PostgresMessageDataDefinition.MessageTable.TEXTUAL_LINE_COUNT, (Object)Optional.ofNullable(message.getTextualLineCount()).orElse(0L).intValue()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_DESCRIPTION, (Object)message.getProperties().getContentDescription()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_TYPE, (Object)message.getProperties().getContentDispositionType()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_ID, (Object)message.getProperties().getContentID()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_MD5, (Object)message.getProperties().getContentMD5()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_LANGUAGE, (Object)message.getProperties().getContentLanguage().toArray(new String[0])).set(PostgresMessageDataDefinition.MessageTable.CONTENT_LOCATION, (Object)message.getProperties().getContentLocation()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_TRANSFER_ENCODING, (Object)message.getProperties().getContentTransferEncoding()).set(PostgresMessageDataDefinition.MessageTable.CONTENT_TYPE_PARAMETERS, (Object)Hstore.hstore((Map)message.getProperties().getContentTypeParameters())).set(PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_PARAMETERS, (Object)Hstore.hstore((Map)message.getProperties().getContentDispositionParameters())).set(PostgresMessageDataDefinition.MessageTable.ATTACHMENT_METADATA, (Object)AttachmentsDTO.from(message.getAttachments())).set(PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT, headerContentAsByte))));
    }

    public Mono<MessageRepresentation> retrieveMessage(PostgresMessageId messageId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, PostgresMessageDataDefinition.MessageTable.SIZE, PostgresMessageDataDefinition.MessageTable.BODY_START_OCTET, PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT, PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID, PostgresMessageDataDefinition.MessageTable.ATTACHMENT_METADATA).from(PostgresMessageDataDefinition.MessageTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID.eq((Object)messageId.asUuid())))).map(record -> this.toMessageRepresentation((Record)record, messageId));
    }

    private MessageRepresentation toMessageRepresentation(Record record, MessageId messageId) {
        return MessageRepresentation.builder().messageId(messageId).internalDate((Date)PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION.apply((LocalDateTime)record.get(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, LocalDateTime.class))).size((Long)record.get(PostgresMessageDataDefinition.MessageTable.SIZE)).headerContent(PostgresMailboxMessageDAOUtils.BYTE_TO_CONTENT_FUNCTION.apply((byte[])record.get(PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT))).bodyBlobId(this.blobIdFactory.parse((String)record.get(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID))).attachments((List)record.get(PostgresMessageDataDefinition.MessageTable.ATTACHMENT_METADATA)).build();
    }

    public Mono<Void> deleteByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMessageDataDefinition.MessageTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID.eq((Object)messageId.asUuid()))));
    }

    public Mono<BlobId> getBodyBlobId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID).from(PostgresMessageDataDefinition.MessageTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID.eq((Object)messageId.asUuid())))).map(record -> this.blobIdFactory.parse((String)record.get(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID)));
    }

    public Flux<BlobId> listBlobs() {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID).from(PostgresMessageDataDefinition.MessageTable.TABLE_NAME))).map(record -> this.blobIdFactory.parse((String)record.get(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID)));
    }

    public static class Factory {
        private final BlobId.Factory blobIdFactory;
        private final PostgresExecutor.Factory executorFactory;

        @Inject
        @Singleton
        public Factory(BlobId.Factory blobIdFactory, PostgresExecutor.Factory executorFactory) {
            this.blobIdFactory = blobIdFactory;
            this.executorFactory = executorFactory;
        }

        public PostgresMessageDAO create(Optional<Domain> domain) {
            return new PostgresMessageDAO(this.executorFactory.create(domain), this.blobIdFactory);
        }
    }
}

