/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface HttpSecurityPolicy {
    public Uni<CheckResult> checkPermission(RoutingContext var1, Uni<SecurityIdentity> var2, AuthorizationRequestContext var3);

    default public String name() {
        return null;
    }

    public static class DefaultAuthorizationRequestContext
    implements AuthorizationRequestContext {
        private final BlockingSecurityExecutor blockingExecutor;

        DefaultAuthorizationRequestContext(BlockingSecurityExecutor blockingExecutor) {
            this.blockingExecutor = blockingExecutor;
        }

        @Override
        public Uni<CheckResult> runBlocking(final RoutingContext context, Uni<SecurityIdentity> identityUni, final BiFunction<RoutingContext, SecurityIdentity, CheckResult> function) {
            return identityUni.flatMap((Function)new Function<SecurityIdentity, Uni<? extends CheckResult>>(){

                @Override
                public Uni<? extends CheckResult> apply(final SecurityIdentity identity) {
                    return blockingExecutor.executeBlocking((Supplier)new Supplier<CheckResult>(){

                        @Override
                        public CheckResult get() {
                            return (CheckResult)function.apply(context, identity);
                        }
                    });
                }
            });
        }
    }

    public static interface AuthorizationRequestContext {
        public Uni<CheckResult> runBlocking(RoutingContext var1, Uni<SecurityIdentity> var2, BiFunction<RoutingContext, SecurityIdentity, CheckResult> var3);
    }

    public static class CheckResult {
        public static CheckResult DENY = new CheckResult(false);
        public static CheckResult PERMIT = new CheckResult(true);
        private final boolean permitted;
        private final SecurityIdentity augmentedIdentity;

        public CheckResult(boolean permitted) {
            this.permitted = permitted;
            this.augmentedIdentity = null;
        }

        public CheckResult(boolean permitted, SecurityIdentity augmentedIdentity) {
            this.permitted = permitted;
            this.augmentedIdentity = augmentedIdentity;
        }

        public boolean isPermitted() {
            return this.permitted;
        }

        public SecurityIdentity getAugmentedIdentity() {
            return this.augmentedIdentity;
        }

        public Uni<SecurityIdentity> getAugmentedIdentityAsUni() {
            return Uni.createFrom().item((Object)this.augmentedIdentity);
        }

        public static Uni<CheckResult> permit() {
            return Uni.createFrom().item((Object)PERMIT);
        }

        public static Uni<CheckResult> deny() {
            return Uni.createFrom().item((Object)DENY);
        }
    }
}

