/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;

public abstract class TableLikeEntity
extends PolarisEntity
implements LocationBasedEntity {
    public TableLikeEntity(@Nonnull PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.TABLE_LIKE ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
    }

    @JsonIgnore
    public TableIdentifier getTableIdentifier() {
        Namespace parent = this.getParentNamespace();
        return TableIdentifier.of((Namespace)parent, (String)this.getName());
    }

    @JsonIgnore
    public Namespace getParentNamespace() {
        String encodedNamespace = this.getInternalPropertiesAsMap().get("parent-namespace");
        if (encodedNamespace == null) {
            return Namespace.empty();
        }
        return RESTUtil.decodeNamespace((String)encodedNamespace);
    }
}

