/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisCredentialVendor;
import org.apache.polaris.core.storage.cache.StorageCredentialCacheEntry;
import org.apache.polaris.core.storage.cache.StorageCredentialCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCredentialCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageCredentialCache.class);
    private static final long CACHE_MAX_NUMBER_OF_ENTRIES = 10000L;
    private final LoadingCache<StorageCredentialCacheKey, StorageCredentialCacheEntry> cache = Caffeine.newBuilder().maximumSize(10000L).expireAfter(Expiry.creating((key, entry) -> {
        long expireAfterMillis = Math.max(0L, Math.min((entry.getExpirationTime() - System.currentTimeMillis()) / 2L, StorageCredentialCache.maxCacheDurationMs()));
        return Duration.ofMillis(expireAfterMillis);
    })).build(key -> null);

    private static long maxCacheDurationMs() {
        Integer cacheDurationSeconds = PolarisConfiguration.loadConfig(FeatureConfiguration.STORAGE_CREDENTIAL_CACHE_DURATION_SECONDS);
        Integer credentialDurationSeconds = PolarisConfiguration.loadConfig(FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS);
        if (cacheDurationSeconds >= credentialDurationSeconds) {
            throw new IllegalArgumentException(String.format("%s should be less than %s", FeatureConfiguration.STORAGE_CREDENTIAL_CACHE_DURATION_SECONDS.key, FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS.key));
        }
        return (long)cacheDurationSeconds.intValue() * 1000L;
    }

    public AccessConfig getOrGenerateSubScopeCreds(@Nonnull PolarisCredentialVendor credentialVendor, @Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntity polarisEntity, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
        if (!this.isTypeSupported(polarisEntity.getType())) {
            callCtx.getDiagServices().fail("entity_type_not_suppported_to_scope_creds", "type={}", new Object[]{polarisEntity.getType()});
        }
        StorageCredentialCacheKey key = new StorageCredentialCacheKey(polarisEntity, allowListOperation, allowedReadLocations, allowedWriteLocations, callCtx);
        LOGGER.atDebug().addKeyValue("key", (Object)key).log("subscopedCredsCache");
        Function<StorageCredentialCacheKey, StorageCredentialCacheEntry> loader = k -> {
            LOGGER.atDebug().log("StorageCredentialCache::load");
            ScopedCredentialsResult scopedCredentialsResult = credentialVendor.getSubscopedCredsForEntity(k.getCallContext(), k.getCatalogId(), k.getEntityId(), polarisEntity.getType(), k.isAllowedListAction(), k.getAllowedReadLocations(), k.getAllowedWriteLocations());
            if (scopedCredentialsResult.isSuccess()) {
                return new StorageCredentialCacheEntry(scopedCredentialsResult);
            }
            LOGGER.atDebug().addKeyValue("errorMessage", (Object)scopedCredentialsResult.getExtraInformation()).log("Failed to get subscoped credentials");
            throw new UnprocessableEntityException("Failed to get subscoped credentials: %s", new Object[]{scopedCredentialsResult.getExtraInformation()});
        };
        return ((StorageCredentialCacheEntry)this.cache.get((Object)key, loader)).toAccessConfig();
    }

    @Nullable
    @VisibleForTesting
    Map<String, String> getIfPresent(StorageCredentialCacheKey key) {
        return this.getAccessConfig(key).map(AccessConfig::credentials).orElse(null);
    }

    @VisibleForTesting
    Optional<AccessConfig> getAccessConfig(StorageCredentialCacheKey key) {
        return Optional.ofNullable((StorageCredentialCacheEntry)this.cache.getIfPresent((Object)key)).map(StorageCredentialCacheEntry::toAccessConfig);
    }

    private boolean isTypeSupported(PolarisEntityType type) {
        return type == PolarisEntityType.CATALOG || type == PolarisEntityType.NAMESPACE || type == PolarisEntityType.TABLE_LIKE || type == PolarisEntityType.TASK;
    }

    @VisibleForTesting
    public long getEstimatedSize() {
        return this.cache.estimatedSize();
    }
}

