/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.fs.util.sysfs;

import io.quarkus.fs.util.base.DelegatingFileSystemProvider;
import io.quarkus.fs.util.base.DelegatingPath;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ConfigurableFileSystemProviderWrapper
extends DelegatingFileSystemProvider {
    private final Set<AccessMode> allowedAccessModes;

    public ConfigurableFileSystemProviderWrapper(FileSystemProvider delegate, Set<AccessMode> allowedAccessModes) {
        super(delegate);
        this.allowedAccessModes = Objects.requireNonNullElse(allowedAccessModes, Collections.emptySet());
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (modes.length > 0 && !this.allowedAccessModes.isEmpty()) {
            ArrayList<AccessMode> accessModes = new ArrayList<AccessMode>(3);
            for (AccessMode mode : modes) {
                if (this.allowedAccessModes.contains((Object)mode)) continue;
                accessModes.add(mode);
            }
            if (accessModes.isEmpty()) {
                return;
            }
            modes = accessModes.toArray(new AccessMode[0]);
        }
        this.delegate.checkAccess(DelegatingPath.unwrap(path), modes);
    }
}

