/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import java.util.List;

public interface EmbeddingStore<Embedded> {
    public String add(Embedding var1);

    public void add(String var1, Embedding var2);

    public String add(Embedding var1, Embedded var2);

    public List<String> addAll(List<Embedding> var1);

    public List<String> addAll(List<Embedding> var1, List<Embedded> var2);

    @Experimental
    default public EmbeddingSearchResult<Embedded> search(EmbeddingSearchRequest request) {
        List<EmbeddingMatch<Embedded>> matches = this.findRelevant(request.queryEmbedding(), request.maxResults(), request.minScore());
        return new EmbeddingSearchResult<Embedded>(matches);
    }

    default public List<EmbeddingMatch<Embedded>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.findRelevant(referenceEmbedding, maxResults, 0.0);
    }

    default public List<EmbeddingMatch<Embedded>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(referenceEmbedding).maxResults(maxResults).minScore(minScore).build();
        EmbeddingSearchResult<Embedded> embeddingSearchResult = this.search(embeddingSearchRequest);
        return embeddingSearchResult.matches();
    }

    default public List<EmbeddingMatch<Embedded>> findRelevant(Object memoryId, Embedding referenceEmbedding, int maxResults) {
        return this.findRelevant(memoryId, referenceEmbedding, maxResults, 0.0);
    }

    default public List<EmbeddingMatch<Embedded>> findRelevant(Object memoryId, Embedding referenceEmbedding, int maxResults, double minScore) {
        throw new RuntimeException("Not implemented");
    }
}

