/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class StreamPartitionWithWatermark
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -318960470803696894L;
    final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition;
    final @UnknownKeyFor @NonNull @Initialized Instant watermark;

    public StreamPartitionWithWatermark(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized Instant watermark) {
        this.partition = partition;
        this.watermark = watermark;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange getPartition() {
        return this.partition;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return this.watermark;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamPartitionWithWatermark)) {
            return false;
        }
        StreamPartitionWithWatermark that = (StreamPartitionWithWatermark)o;
        return Objects.equals(this.getPartition(), that.getPartition()) && Objects.equals(this.getWatermark(), that.getWatermark());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getPartition(), this.getWatermark());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "StreamPartitionWithWatermark{partition=" + ByteStringRangeHelper.formatByteStringRange(this.partition) + ", watermark=" + this.watermark + '}';
    }
}

