/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import lombok.Generated;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsv;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsvData;
import org.apache.hop.neo4j.transforms.gencsv.UniquenessStrategy;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4jLoad", name="i18n::GenerateCsvMeta.name", description="i18n::GenerateCsvMeta.description", image="neo4j_load.svg", categoryDescription="i18n::GenerateCsvMeta.categoryDescription", keywords={"i18n::GenerateCsvMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-gencsv.html")
public class GenerateCsvMeta
extends BaseTransformMeta<GenerateCsv, GenerateCsvData> {
    @HopMetadataProperty(key="graph_field_name")
    protected String graphFieldName;
    @HopMetadataProperty(key="base_folder")
    protected String baseFolder;
    @HopMetadataProperty(key="uniqueness_strategy")
    protected UniquenessStrategy uniquenessStrategy;
    @HopMetadataProperty(key="files_prefix")
    protected String filesPrefix;
    @HopMetadataProperty(key="filename_field")
    protected String filenameField;
    @HopMetadataProperty(key="file_type_field")
    protected String fileTypeField;

    public void setDefault() {
        this.baseFolder = "/var/lib/neo4j/";
        this.uniquenessStrategy = UniquenessStrategy.None;
        this.filesPrefix = "prefix";
        this.filenameField = "filename";
        this.fileTypeField = "fileType";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) {
        inputRowMeta.clear();
        ValueMetaString filenameValueMeta = new ValueMetaString(space.resolve(this.filenameField));
        filenameValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)filenameValueMeta);
        ValueMetaString fileTypeValueMeta = new ValueMetaString(space.resolve(this.fileTypeField));
        fileTypeValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)fileTypeValueMeta);
    }

    @Generated
    public String getGraphFieldName() {
        return this.graphFieldName;
    }

    @Generated
    public String getBaseFolder() {
        return this.baseFolder;
    }

    @Generated
    public UniquenessStrategy getUniquenessStrategy() {
        return this.uniquenessStrategy;
    }

    @Generated
    public String getFilesPrefix() {
        return this.filesPrefix;
    }

    @Generated
    public String getFilenameField() {
        return this.filenameField;
    }

    @Generated
    public String getFileTypeField() {
        return this.fileTypeField;
    }

    @Generated
    public void setGraphFieldName(String graphFieldName) {
        this.graphFieldName = graphFieldName;
    }

    @Generated
    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    @Generated
    public void setUniquenessStrategy(UniquenessStrategy uniquenessStrategy) {
        this.uniquenessStrategy = uniquenessStrategy;
    }

    @Generated
    public void setFilesPrefix(String filesPrefix) {
        this.filesPrefix = filesPrefix;
    }

    @Generated
    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Generated
    public void setFileTypeField(String fileTypeField) {
        this.fileTypeField = fileTypeField;
    }
}

