/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SharingFileAccessError {
    NO_PERMISSION,
    INVALID_FILE,
    IS_FOLDER,
    INSIDE_PUBLIC_FOLDER,
    INSIDE_OSX_PACKAGE,
    OTHER;


    static class Serializer
    extends UnionSerializer<SharingFileAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharingFileAccessError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case INVALID_FILE: {
                    g.writeString("invalid_file");
                    break;
                }
                case IS_FOLDER: {
                    g.writeString("is_folder");
                    break;
                }
                case INSIDE_PUBLIC_FOLDER: {
                    g.writeString("inside_public_folder");
                    break;
                }
                case INSIDE_OSX_PACKAGE: {
                    g.writeString("inside_osx_package");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SharingFileAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            SharingFileAccessError value = "no_permission".equals(tag) ? NO_PERMISSION : ("invalid_file".equals(tag) ? INVALID_FILE : ("is_folder".equals(tag) ? IS_FOLDER : ("inside_public_folder".equals(tag) ? INSIDE_PUBLIC_FOLDER : ("inside_osx_package".equals(tag) ? INSIDE_OSX_PACKAGE : OTHER))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

